%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Calculation of the thermal conductivity of a two phase system           %
% Weighted harmonic mean                                                  %
% Nelson Molina-Giraldo 2011                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function lm = Tcond_harmonic(ls,lw,n)
lm = 1./(n/lw+(1-n)./ls);

% lm: thermal conductivity of the two phase system
% lw: thermal conductivity of the fluid phase
% ls: thermal conductivity of the solid phase
% n: porosity 


